package org.msh.tb.reports2.variables.contacts;

import org.msh.reports.filters.FilterOperation;
import org.msh.reports.filters.ValueHandler;
import org.msh.reports.query.SQLDefs;
import org.msh.tb.entities.enums.TbField;
import org.msh.tb.reports2.variables.FieldValueVariable;

/**
 * Created by rmemoria on 30/3/17.
 */
public class ContactFieldValueVariable extends FieldValueVariable {

    public ContactFieldValueVariable(String id, String keylabel, String fieldName, TbField tbfield) {
        super(id, keylabel, fieldName, tbfield);
    }


    @Override
    public void prepareVariableQuery(SQLDefs def, int iteration) {
        String alias = def.table("tbcase").join("id", "tbcontact.case_id").getAlias();
        def.addRestriction(alias + ".gender is not null");
        def.select(alias + "." + getFieldName());
    }

    @Override
    public void prepareFilterQuery(SQLDefs def, FilterOperation oper, ValueHandler value) {
        String alias = def.table("tbcase").join("id", "tbcontact.case_id").getAlias();
        def.addRestriction(alias + ".gender is not null");
        setFieldName(alias + "." + getFieldName());
        super.prepareFilterQuery(def, oper, value);
    }
}
